--this is a include file for unstables in level tutorial
require 'g_level'

--here I'm creating a frame for the basic unstable
unst_layer = 6

function create_stone_unstable(x,y)
    local segment_width = 160.0
    local vertical_offset = 60.0

    local unst_id = g_level.give_id()
    lua:unstablefloor_create(unst_id, 10.0, 1.0,unst_layer) --code, appeartime, disappeartime (in something),layer

    local seg_id = g_level.give_id()
    lua:create_segment_with_code(x-(segment_width/2), y, x+(segment_width/2),  y, seg_id)
    lua:upload_segmentstrip()

    lua:unstablefloor_segmentstrip(unst_id, seg_id) --floorcode, segmentstrip code
    
    local scale = 0.66
    local width = 256.0/2*scale
    local height = 256.0/2*scale
    lua:create_sprite("appear", ST_ANIMATED,"unstable_appear", x,y-vertical_offset) 
    lua:sprite_shape("appear",ST_ANIMATED,width, height)
    lua:create_sprite("rumble", ST_ANIMATED,"unstable_rumble", x,y-vertical_offset) 
    lua:sprite_shape("rumble",ST_ANIMATED,width, height)
    lua:create_sprite("dissappear", ST_ANIMATED,"unstable_disappear", x,y-vertical_offset) 
    lua:sprite_shape("dissappear",ST_ANIMATED,width, height)

    lua:unstablefloor_animations(unst_id,"appear","dissappear","rumble") --code, appear, disappear, rumble

    lua:create_sound("appear","data/music/effect_stereo.ogg", 360.0, 0.0, 0.0)
    lua:create_sound("disappear","data/music/effect_stereo.ogg", 360.0, 0.0, 0.0)
    lua:create_music("rumble","data/music/disturbed.ogg")
    lua:unstablefloor_audio(unst_id,"appear","disappear","rumble") --code, appear_sound, disappear_sound, rumble_sound
end

--LOAD GRAPHICS
local delay = 0.025
lua_init_texture_animation("unstable_disappear","data/images/sewer/unstablefloor/disappear/", 19, MODE_ONCE, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
local delay = 0.125
lua_init_texture_animation("unstable_appear","data/images/sewer/unstablefloor/appear/", 10, MODE_ONCE, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
local delay = 0.125
lua_init_texture_animation("unstable_rumble","data/images/sewer/unstablefloor/rumble/", 5, MODE_PINGPONG, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
